#ifndef _MAINFORM_H
#define _MAINFORM_H

#include <QMainWindow>
#include <QtGui>

class QSqlTableModel;
class ResultTab;
class QueryTab;
class QSplitter;
class DatabaseTree;
class QTabBar;
class QListView;
class CodeTemplateTree;
class tablewidget;
class tablewidget1;
class tablewidget2;
class IntroModeSelectDlg;
class DebugModeValue;
class NumberLine;


class MainForm : public QMainWindow
{
	Q_OBJECT

	public:
		MainForm(QWidget * parent = 0, Qt::WindowFlags flags = 0);
		virtual ~MainForm();

	public slots:
		void SetName();
		void Test();
		void DisplayTableData();
		void DisplayCodeTemplate();
		void DropTable();
		void EmptyTable();
		void RenameTable();
		void CreateStoredProcedure();
		void AlterStoredProcedure();
		void DropStoredProcedure();
		void DropFunction();
		void CreateFunction();
		void CreateDialog();
		void CreateView();
		void AlterView();
		void DropView();
		void RenameView();
		void AlterFunction();
		void CreateTrigger();
		void AlterTrigger();
		void DropTrigger();
		void ManageColumn();
		void ExportToXML();
		void SaveTabWidget();
		void OpenTabWidget();
		void NewQueryTab();
		void NewConnection();
		void RefreshTable();
		void ExcuteQuery();
		void ExcuteSelectedQuery();
		void Disconnect();
		void InsertRowInTableModel();
		void DeleteRowInTableModel();
		void ExcuteTableData();
		void CreateDatabase();
		void DropDatabase();
		void Run();
		void Stop();
		void CreateTable();
		void StepInto();
		void AlterTable();
		void SetRelation();
				
	public:		
		void CreateDockWidget();
		void CreateActions();
		void CreateMenus();
		void CreateToolbars();
		void SetLayout();
		int CheckCurrentItemIsTable();
		void ExportToXMLFile(QString& fileName);
		void NewSetting();
		void CreateStatusBar();
		void DebugValueReset();
		void ExcuteQeury(QString& string);

		
		
	public:
		QSplitter* GetHorizontalSplitter() const;
		QSplitter* GetVerticalSplitter() const;
		DatabaseTree* GetFolderView() const;
		QueryTab* GetQueryTab() const;
		ResultTab* GetResultTab() const;
		tablewidget* Get_breakpointinfotable(){ return breakPointInfoTable; }
		IntroModeSelectDlg* GetModeDialog(){ return this->modeDialog; }
		//int GetDebuggingMode() const;
		//void SetDebuggingMode(int mode);

		//QList<tableProperty*>& GetTables();
		//QList<RelationInfo*>& GetRelationInfo();

		//void SetTables(QList<tableProperty*>& other);
		//void SetRelationInfo(QList<tableProperty*>& other);

	protected:
		void closeEvent ( QCloseEvent * event );
		//void keyPressEvent ( QKeyEvent * event );

	public:
		QList <QString> listvalue;
		QList <QString> listvalue1;
		QList <QString> listvalue2;
		QList <QString> listvalue3;
		QList <int> numberLineReturns;

	private:
		QSplitter* horizontalSplitter;
		QSplitter* verticalSplitter;
		DatabaseTree* folderView;
		CodeTemplateTree* codeTemplate;
		QueryTab* queryTab;
		ResultTab* resultTab;
		DebugModeValue* debugModeValues;
		
		QSqlTableModel* tableModel;
		
		QString name;
		QDialog* newName;

		QDockWidget* dock;
		//kang
		QDockWidget* codeTemplateDock;

		QMenu* fileMenu;
		QMenu* tableMenu;
		QMenu* objectMenu;
		QMenu* viewMenu;
		QMenu* queryMenu;
		QMenu* debugMenu;

		QToolBar* fileToolBar;
		QToolBar* tableToolBar;
		QToolBar* queryToolBar;
		QToolBar* debugToolBar;

		QAction* newConnectionAction;
		QAction* newQueryTabAction;
		QAction* disconnectAction;
		QAction* openAction;
		QAction* saveAction;
		QAction* exitAction;

		QAction* createTableAction;
		QAction* alterTableAction;
		QAction* emptyTableAction;
		QAction* dropTableAction;
		QAction* viewDataAction;
		QAction* exportToXmlAction;
		
		QAction* createStoredProcedureAction;
		QAction* alterStoredProcedureAction;
		QAction* dropStoredProcedureAction;
		
		QAction* createFunctionAction;
		QAction* alterFunctionAction;
		QAction* dropFunctionAction;
		
		QAction* createViewAction;
		QAction* alterViewAction;
		QAction* dropViewAction;
		
		QAction* createTriggerAction;
		QAction* alterTriggerAction;
		QAction* dropTriggerAction;
		QAction* refreshTableAction;
		QAction* excuteQueryAction;
		QAction* excuteSelectedQueryAction;
		
		QAction* breakpointAct;
		QAction* allbreakpointcleanAct;
		QAction* runAct;
		QAction* step_intoAct;
		QAction* stopAct;
		
		QDockWidget* breakPointerInfo;
		QDockWidget* callStack;
		QDockWidget* watches;
		
		tablewidget* breakPointInfoTable;
		tablewidget1* callStackInfoTable;
		tablewidget2* watchesInfoTable;

		IntroModeSelectDlg* modeDialog;

		//QList<tableProperty*> tables;
		//QList<RelationInfo*> relationInfo;
		
		int debuggingMode;  // 0 : Ϲݸ, 1 :  
		int numberReturn;
};

inline QSplitter* MainForm::GetHorizontalSplitter() const
{
	return const_cast<QSplitter*>(this->horizontalSplitter);
}

inline QSplitter* MainForm::GetVerticalSplitter() const
{
	return const_cast<QSplitter*>(this->verticalSplitter);
}

inline DatabaseTree* MainForm::GetFolderView() const
{
	return const_cast<DatabaseTree*>(this->folderView);
}

inline QueryTab* MainForm::GetQueryTab() const
{
	return const_cast<QueryTab*>(this->queryTab);
}

inline ResultTab* MainForm::GetResultTab() const
{
	return const_cast<ResultTab*>(this->resultTab);
}
/*
int MainForm::GetDebuggingMode() const
{
	return this->debuggingMode;
}

void MainForm::SetDebuggingMode(int mode)
{
	this->debuggingMode = mode;
}


QList<tableProperty*>& MainForm::GetTables()
{
return this->tables;
}

  QList<RelationInfo*>& MainForm::GetRelationInfo()
  {
  return this->relationInfo;
  }
*/
#endif //_MAINFORM_H
